


//------------------------------------------------------------------------------
//PrnDib Version A.0
//Copyright (c) 1989-2010 by Joe C. Hecht All Rights Reserved
//Copyright (c) 2011-2015 by CODE4SALE, LLC All Rights Reserved
//License: Distribution of this source code prohibited, for inclusion
//in compiled form in your application only, use at your own risk,
//no liability accepted.
//TExcellentHomePage: www.code4sale.com/texcellent
//------------------------------------------------------------------------------



//------------------------------------------------------------------------------
//Note: Version 7.x changes center around support for CB++ XE3/4/5/6/7 Winx64.
//
//Notable changes include:
//
// TAppCallbackFn() is now TPrnFormAppCallbackFn and TPrnDibAppCallbackFn
//
// Some DWORD and PTR_UINT, and PTR_AS_UINT values are now:
// PRNFORM_PTR_UINT
// PRNFORM_PTR_AS_UINT
// PRNDIB_PTR_UINT
// PRNDIB_PTR_AS_UINT
// PRNUTILS_PTR_UINT
// PRNUTILS_PTR_AS_UINT
//------------------------------------------------------------------------------



#ifndef PrnDibH
#define PrnDibH

#pragma hdrstop

#include <Windows.h>

typedef size_t PRNDIB_PTR_AS_UINT;
typedef size_t PRNDIB_PTR_UINT;

#define PRINT_SUCCESSFUL 1
#define NOTHING_TO_PRINT 0
#define BAD_PARAMETER -1
#define MEMORY_ALLOC_FAILED -2
#define MEMORY_READ_FAILED -3
#define MEMORY_WRITE_FAILED -4
#define USER_ABORT_OR_OTHER_ERROR -5


typedef BOOL __stdcall (*TPrnDibAppCallbackFn)(DWORD UnitsDone,              // Number of units completed
                                               DWORD TotalUnits,             // Number of total units to print
                                               PRNDIB_PTR_AS_UINT UserData); // Application defined data or pointer.

int __stdcall PrintDIBitmap(HDC dc,
                            BITMAPINFO * lpBitmapInfo,
                            void * lpBits,
                            BOOL Centered,
                            BOOL UsePerfectMargins);


int __stdcall PrintDIBitmapCB(HDC dc,
                              BITMAPINFO * lpBitmapInfo,
							  void * lpBits,
							  BOOL Centered,
							  BOOL UsePerfectMargins,
							  TPrnDibAppCallbackFn OnAppCallbackFn,
							  PRNDIB_PTR_AS_UINT OnAppCallbackData);

int __stdcall PrintDIBitmapXY(HDC dc,
							  int dstx,
							  int dsty,
							  int dstWidth,
							  int dstHeight,
							  BITMAPINFO * lpBitmapInfo,
							  void * lpBits);

int __stdcall PrintDIBitmapEx(HDC dc,
							  int dstx,
							  int dsty,
							  int dstWidth,
							  int dstHeight,
							  int srcx,
							  int srcy,
							  int srcWidth,
							  int srcHeight,
							  BITMAPINFO * lpBitmapInfo,
							  void * lpBits,
							  HPALETTE Palette,
							  BOOL ForcePalette,
							  BOOL DoNotUsePalette,
							  RECT * DeviceClipRect,
							  TPrnDibAppCallbackFn OnAppCallbackFn,
							  PRNDIB_PTR_AS_UINT OnAppCallbackData);

void __stdcall PrnDIBSetDebugMsg(BOOL value);

void __stdcall PrnDIBSetDebugBltCode(BOOL value);

void __stdcall PrnDIBSetDebugBlt(BOOL value);

void __stdcall PrnDIBSetDebugUseDDB(BOOL value);

void __stdcall PrnDIBSetDebugAutoUseDDB(BOOL value);

void __stdcall PrnDIBSetDebugFrames(BOOL value);

void __stdcall PrnDIBSetDebugPaletteNone();

void __stdcall PrnDIBSetDebugPaletteForce();

void __stdcall PrnDIBSetDebugPaletteNotAllowed();

void __stdcall PrnDIBSetDebugDcSaves(BOOL value);

void __stdcall PrnDIBSetDebugGdiFlush(BOOL value);

void __stdcall PrnDIBSetSleepValue(int value);

HWND __fastcall PrnDIBSetAbortDialogHandle(HWND value);

void __stdcall PrnDIBSetOutputScaleFactor(int x,
                                          int y);

void __stdcall PrnDIBSetDoWinScale(BOOL value);


#endif
