


//------------------------------------------------------------------------------
//PrnForm Version A.0
//Copyright (c) 1989-2010 by Joe C. Hecht All Rights Reserved
//Copyright (c) 2011-2015 by CODE4SALE, LLC All Rights Reserved
//License: Distribution of this source code prohibited, for inclusion
//in compiled form in your application only, use at your own risk,
//no liability accepted.
//TExcellentHomePage: www.code4sale.com/texcellent
//------------------------------------------------------------------------------



//------------------------------------------------------------------------------
//Note: Version 7.x changes center around support for CB++ XE3/4/5/6/7 Winx64.
//
//Notable changes include:
//
// TAppCallbackFn() is now TPrnFormAppCallbackFn and TPrnDibAppCallbackFn
//
// Some DWORD and PTR_UINT, and PTR_AS_UINT values are now:
// PRNFORM_PTR_UINT
// PRNFORM_PTR_AS_UINT
// PRNDIB_PTR_UINT
// PRNDIB_PTR_AS_UINT
// PRNUTILS_PTR_UINT
// PRNUTILS_PTR_AS_UINT
//------------------------------------------------------------------------------



#ifndef PrnFormH
#define PrnFormH
//---------------------------------------------------------------------------
#include <Windows.hpp>
#include <Windows.h>
#include <commctrl.h>
#include <richedit.h>
#include <ComCtrls.hpp>
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include "PrnUtils.h"
//---------------------------------------------------------------------------

typedef size_t PRNFORM_PTR_AS_UINT;
typedef size_t PRNFORM_PTR_UINT;

#pragma pack(push, 1)
typedef struct _TPrintFormData
{
    DWORD StrucSize;
    BOOL UseAbortDialog;
    BOOL DoNotFlushGDICalls;
    BOOL Use24BitOutputOnly;
} TPrintFormData, *PPrintFormData;
#pragma pack(pop)


typedef BOOL __stdcall (*TPrnFormAppCallbackFn)(DWORD UnitsDone,                //Number of units completed
                                                DWORD TotalUnits,               //Number of total units to print
                                                PRNFORM_PTR_AS_UINT UserData);  //Application defined data or pointer.

typedef BOOL __fastcall (__closure *TOnPaintCallbackEvent)(HDC dc);


typedef BOOL __fastcall (__closure *TOnPaintControlCallbackEvent)(Controls::TControl* TheControl,
                                                                  HDC dc);

SIZE __fastcall VirtualClientSize(Controls::TControl* AControl);


POINT __fastcall VirtualClientScrolledOffset(Controls::TControl* AControl);

BOOL __fastcall HasClass(Controls::TControl* AObject,
                         const System::AnsiString AClassName);

BOOL __fastcall PrintForm(Forms::TScrollingWinControl* TheScrollingWinControl,
                          HDC dc,
                          BOOL Centered,
                          BOOL UsePerfectMargins);

BOOL __fastcall PrintFormEx(Forms::TScrollingWinControl* TheScrollingWinControl,
                            HDC dc,
                            BOOL Centered,
                            BOOL UsePerfectMargins,
                            TPrintFormData * lpPrintFormData);

BOOL __fastcall PrintFormXY(Forms::TScrollingWinControl* TheScrollingWinControl,
                            HDC dc,
                            int x,
                            int y,
                            int Width,
                            int Height);

BOOL __fastcall PrintFormXYEx(Forms::TScrollingWinControl* TheScrollingWinControl,
                              HDC dc,
                              int x,
                              int y,
                              int Width,
                              int Height,
                              TPrintFormData * lpPrintFormData);

BOOL __fastcall PrintTScrollingWinControl(Forms::TScrollingWinControl* TheScrollingWinControl,
                                          HDC dc,
                                          int x,
                                          int y,
                                          int Width,
                                          int Height,
                                          const RECT &ClipRect,
                                          BOOL TrueColor,
                                          TPrnFormAppCallbackFn OnAppCallbackFn,
                                          PRNFORM_PTR_AS_UINT OnAppCallbackData,
                                          TOnPaintCallbackEvent	OnPaintCallbackEvent,
                                          TOnPaintControlCallbackEvent OnPaintControlCallbackEvent);

BOOL __fastcall PrintTScrollingWinControlEx(Forms::TScrollingWinControl* TheScrollingWinControl,
                                            HDC dc,
                                            int x,
                                            int y,
                                            int Width,
                                            int Height,
                                            const RECT &ClipRect,
                                            TPrnFormAppCallbackFn OnAppCallbackFn,
                                            PRNFORM_PTR_AS_UINT OnAppCallbackData,
                                            TOnPaintCallbackEvent OnPaintCallbackEvent,
                                            TOnPaintControlCallbackEvent OnPaintControlCallbackEvent,
                                            TPrintFormData * lpPrintFormData);

BOOL __fastcall PrintTCustomForm(Forms::TScrollingWinControl* TheScrollingWinControl,
                                 HDC dc,
                                 int x,
                                 int y,
                                 int Width,
                                 int Height,
                                 const RECT &ClipRect,
                                 TPrinterAbortDialog* AbortDialog,
                                 TOnPaintCallbackEvent	OnPaintCallbackEvent,
                                 TOnPaintControlCallbackEvent OnPaintControlCallbackEvent);



void __fastcall PrnFormSetDebugMsg(BOOL value);

void __fastcall PrnFormSetDebugDoBlt(BOOL value);

void __fastcall PrnFormSetDebugUseDDB(BOOL value);

void __fastcall PrnFormSetDebugAutoUseDDB(BOOL value);

void __fastcall PrnFormSetDebugFrames(BOOL value);

void __fastcall PrnFormSetSleepValue(int value);

HWND __fastcall PrnFormSetAbortDialogHandle(HWND value);

void __fastcall PrnFormSetOutputScaleFactor(int x,
                                            int y);

void __fastcall PrnFormSetDoWinScale(BOOL value);


#endif
