//---------------------------------------------------------------------------------
#include "TExcellentCompilerDefs.h"
#ifdef TEXCELLENT_CPPBUILDER_VERSION_XE_OR_ABOVE
  #include <vcl.h>
#else
  #include <vcl\vcl.h>
#endif
#pragma hdrstop
//------------------------------------------------------------------------------
#pragma link "PrnUtils"
#pragma link "PrnForm"
#pragma link "PrnDIB"
//------------------------------------------------------------------------------
#include "TExcellentExampleMain.h"
//------------------------------------------------------------------------------
#include "shellapi.h"
#include "Printers.hpp"
//------------------------------------------------------------------------------
#include "PrnDib.h"
#include "PrnForm.h"
#include "PrnUtils.h"
//------------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
//------------------------------------------------------------------------------



//------------------------------------------------------------------------------
TForm1 *Form1;
//------------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
}
//------------------------------------------------------------------------------



//------------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
//------------------------------------------------------------------------------
{

  this->Caption = "TExcellent Form & Image Printer - VA.0";
  #ifdef TEXCELLENT_CPPBUILDER_VERSION_1
    this->Caption = this->Caption + "-C++1";
  #endif
  #ifdef TEXCELLENT_CPPBUILDER_VERSION_2
    this->Caption = this->Caption + "-C++2";
  #endif
  #ifdef TEXCELLENT_CPPBUILDER_VERSION_3
    this->Caption = this->Caption + "-C++3";
  #endif
  #ifdef TEXCELLENT_CPPBUILDER_VERSION_4
    this->Caption = this->Caption + "-C++4";
  #endif
  #ifdef TEXCELLENT_CPPBUILDER_VERSION_5
    this->Caption = this->Caption + "-C++5";
  #endif
  #ifdef TEXCELLENT_CPPBUILDER_VERSION_6
    this->Caption = this->Caption + "-C++6";
  #endif
  #ifdef TEXCELLENT_CPPBUILDER_VERSION_7
    this->Caption = this->Caption + "-C++7";
  #endif
  #ifdef TEXCELLENT_CPPBUILDER_VERSION_8
    this->Caption = this->Caption + "-C++8";
  #endif
  #ifdef TEXCELLENT_CPPBUILDER_VERSION_2005
    this->Caption = this->Caption + "-C++2005";
  #endif
  #ifdef TEXCELLENT_CPPBUILDER_VERSION_2006
    this->Caption = this->Caption + "-C++2006";
  #endif
  #ifdef TEXCELLENT_CPPBUILDER_VERSION_2007
    this->Caption = this->Caption + "-C++2007";
  #endif
  #ifdef TEXCELLENT_CPPBUILDER_VERSION_2009
    this->Caption = this->Caption + "-C++2009";
  #endif
  #ifdef TEXCELLENT_CPPBUILDER_VERSION_2010
    this->Caption = this->Caption + "-C++2010";
  #endif
  #ifdef TEXCELLENT_CPPBUILDER_VERSION_XE
    this->Caption = this->Caption + "-C++XE";
  #endif
  #ifdef TEXCELLENT_CPPBUILDER_VERSION_XE2
    this->Caption = this->Caption + "-C++XE2";
  #endif
  #ifdef TEXCELLENT_CPPBUILDER_VERSION_XE3
    this->Caption = this->Caption + "-C++XE3";
  #endif
  #ifdef TEXCELLENT_CPPBUILDER_VERSION_XE4
    this->Caption = this->Caption + "-C++XE4";
  #endif
  #ifdef TEXCELLENT_CPPBUILDER_VERSION_XE5
    this->Caption = this->Caption + "-C++XE5";
  #endif
  #ifdef TEXCELLENT_CPPBUILDER_VERSION_XE6
    this->Caption = this->Caption + "-C++XE6";
  #endif
  #ifdef TEXCELLENT_CPPBUILDER_VERSION_XE7
    this->Caption = this->Caption + "-C++XE7";
  #endif
  #ifdef TEXCELLENT_CPPBUILDER_VERSION_XE8
    this->Caption = this->Caption + "-C++XE8";
  #endif
  #ifdef TEXCELLENT_CPPBUILDER_VERSION_XE0A
    this->Caption = this->Caption + "-C++XE10";
  #endif
  switch (sizeof(void*)) {
    case 4 :
	  this->Caption = this->Caption + "x86";
	  break;
	case 8 :
	  this->Caption = this->Caption + "x64";
	  break;
  }
  // Load test.bmp into the Image1 component
  if (! FileExists("test.bmp")) {
	if (! FileExists("..\\test.bmp")) {
	  if (! FileExists("..\\..\\test.bmp")) {
		 ShowMessage("Error - test.bmp not found!");
	  } else {
		Image1->Picture->LoadFromFile("..\\..\\test.bmp");
	  }
	} else {
	  Image1->Picture->LoadFromFile("..\\test.bmp");
	}
  } else {
	Image1->Picture->LoadFromFile("test.bmp");
  }
  #ifdef TEXCELLENT_CPPBUILDER_VERSION_1
   LabelMailToSales->Cursor = crDrag;
   LabelMailToSupport->Cursor = crDrag;
   LabelTryOfficialDemoApplication->Cursor = crDrag;
  #else
   LabelMailToSales->Cursor = crHandPoint;
   LabelMailToSupport->Cursor = crHandPoint;
   LabelTryOfficialDemoApplication->Cursor = crHandPoint;
  #endif
}
//------------------------------------------------------------------------------



//------------------------------------------------------------------------------
//-- Print the form scaled to a full page - with options! -------------------
//------------------------------------------------------------------------------
void __fastcall TForm1::ButtonPrintFormClick(TObject *Sender)
//------------------------------------------------------------------------------
{
  TPrintFormData PrintOptions;
  TPrnPageInfo PrnPageInfo;  //{Info about the page to be printed}

  // Let the button repaint itself from the click event
  Application->ProcessMessages();


  // Are we printing something right now?
  if (Printer()->Printing) {
    ShowMessage("Already printing... Please try again later!");
    return;
  }

  // Let the user select a printer
  if (! PrintDialog1->Execute()) {
    return;
  }

  // Prepare to set printing options
  memset(&PrintOptions, 0, sizeof(PrintOptions));
  PrintOptions.StrucSize = sizeof(PrintOptions);

  // Lets show a status dialog during the print job!
  PrintOptions.UseAbortDialog = TRUE;

  // Lets show messages if there are problems printing the form
  PrnFormSetDebugMsg(TRUE);

  // Allow the user to force the use 24 bit printing for problem printers
  PrintOptions.Use24BitOutputOnly = CheckBox24BitFormOutput->Checked;

  // Allow user to force the use of DDBs for problem printers or speed up the print job
  PrnFormSetDebugUseDDB(CheckBoxUseDDB->Checked);

  // Set print job size reduction factor
  if (CheckBoxCompress->Checked) {
    PrnFormSetOutputScaleFactor(2, 2);
  } else {
    PrnFormSetOutputScaleFactor(1, 1);
  }

  // Set WinScale
  if (CheckBoxWinStretch->Checked) {
    PrnFormSetOutputScaleFactor(1, 1);
    PrnFormSetDoWinScale(TRUE);
  } else {
    PrnFormSetDoWinScale(FALSE);
  }

  // Start the print job!
  Printer()->BeginDoc();

  // Print the form!
  if (! PrintFormEx(this,
                    Printer()->Canvas->Handle,
                    TRUE, // Center the form on the page
                    TRUE, // Adjust for perfect margins
                    &PrintOptions)) {
    // Abort the print job!
    Printer()->Abort();
    ShowMessage("User abort or other error!");
  } else {
    //{get the page information}
    GetPrnPageInfo(Printer()->Handle,
                   &PrnPageInfo);
    //{print a notice that demo mode prints lines across the output}
    Printer()->Canvas->Font->Name = "Arial";
    Printer()->Canvas->Font->Size = 12;
    Printer()->Canvas->TextOut(PrnPageInfo.Margin.left,
                               PrnPageInfo.Margin.top,
                               "Note: Demo mode prints lines across the output.");
    // End the print job!
    Printer()->EndDoc();
  }

  // We are done!
  ShowMessage("Printing Completed!");

}
//------------------------------------------------------------------------------



//------------------------------------------------------------------------------
//-- A callback function for updating an image printer abort dialog! --------
//------------------------------------------------------------------------------
BOOL __stdcall ImagePrinterCallbackFunction(DWORD UnitsDone,
                                            DWORD TotalUnits,
                                            TAbortDialog * AbortDialog)
//------------------------------------------------------------------------------
{
  TCaption ACaption;

  // Update the abort dialogs caption to give a status update
  ACaption = "Printing  - " +
             IntToStr(INT((((float)UnitsDone / (float)TotalUnits) * 100))) +
             "%";
  AbortDialogSetCaption(AbortDialog,
                        ACaption);
  // Return if the user has canceled the print job.
  return(! AbortDialogUserHasCanceled(AbortDialog));
}
//------------------------------------------------------------------------------



//------------------------------------------------------------------------------
//-- Print test.bmp scaled to a full page - with abort dialog! --------------
//------------------------------------------------------------------------------
void __fastcall TForm1::ButtonPrintImageClick(TObject *Sender)
{
  TFileName FileName;         // The filename of the image
  TAbortDialog *AbortDialog;  // The abort dialog
  BITMAPINFO * BitmapInfo;    // A pointer to a BitmapInfo structure
  void * Bits;                // A pointer to the bitmap bits
  int BitmapWidth;            // The bitmap width
  int BitmapHeight;           // The bitmap height
  TPrnPageInfo PrnPageInfo;   // Info about the page to be printed

  // Let the button repaint itself from the click event
  Application->ProcessMessages();

  // Are we printing something right now?
  if (Printer()->Printing) {
    ShowMessage("Already printing... Please try again later!");
    return;
  }

  // Do we have a bitmap to print?
  if (! FileExists("test.bmp")) {
	if (! FileExists("..\\test.bmp")) {
	  if (! FileExists("..\\..\\test.bmp")) {
		ShowMessage("Error - test.bmp not found!");
		return;
	  } else {
		FileName = "..\\..\\test.bmp";
	  }
	} else {
	  FileName = "..\\test.bmp";
	}
  } else {
	FileName = "test.bmp";
  }

  // Let the user select a printer
  if (! PrintDialog1->Execute()) {
    return;
  }

  // Load test.bmp as a Device Independent Bitmap
  if (! LoadDIBFromFile(FileName,
                        (PVOID*)&BitmapInfo,
                        &Bits,
                        &BitmapWidth,
                        &BitmapHeight)){
    ShowMessage("Bitmap load error");
    return;
  }

  // Create the abort dialog
  AbortDialog = CreateAbortDialog(Application->Handle, this);
  PrnDIBSetAbortDialogHandle(AbortDialog->Handle);

  // Lets show messages if there are problems printing the form
  PrnDIBSetDebugMsg(TRUE);

  // Allow user to force the use of DDBs for problem printers or speed up the print job
  PrnDIBSetDebugUseDDB(CheckBoxUseDDB->Checked);

  // Set print job size reduction factor
  if (CheckBoxCompress->Checked) {
    PrnDIBSetOutputScaleFactor(2, 2);
  } else {
    PrnDIBSetOutputScaleFactor(1, 1);
  }

  // Set WinScale
  if (CheckBoxWinStretch->Checked) {
    PrnDIBSetDoWinScale(TRUE);
    PrnDIBSetOutputScaleFactor(1, 1);
  } else {
    PrnDIBSetDoWinScale(FALSE);
  }

  // Start the print job!
  Printer()->BeginDoc();

  // Print the image!
  if (PrintDIBitmapCB(Printer()->Canvas->Handle,
                      BitmapInfo,
                      Bits,
                      TRUE,
                      TRUE,
                      (TPrnDibAppCallbackFn)ImagePrinterCallbackFunction,
                      (PRNDIB_PTR_AS_UINT)AbortDialog) < PRINT_SUCCESSFUL) {
    // Abort the print job!
    Printer()->Abort();
    ShowMessage("User abort or other error!");
  } else {
    //{get the page information}
    GetPrnPageInfo(Printer()->Handle,
                   &PrnPageInfo);
    //{print a notice that demo mode prints lines across the output}
    Printer()->Canvas->Font->Name = "Arial";
    Printer()->Canvas->Font->Size = 12;
    Printer()->Canvas->TextOut(PrnPageInfo.Margin.left,
                               PrnPageInfo.Margin.top,
                               "Note: Demo mode prints lines across the output.");
    // End the print job!
    Printer()->EndDoc();
  }

  // Clean Up!
  FreeMemEx(BitmapInfo);
  FreeMemEx(Bits);
  FreeAbortDialog(AbortDialog);
  PrnDIBSetAbortDialogHandle(0);

  // We are done!
  ShowMessage("Printing Completed!");

}
//------------------------------------------------------------------------------



//------------------------------------------------------------------------------
void __fastcall TForm1::ButtonGetDocumentationClick(TObject *Sender)
//------------------------------------------------------------------------------
{
  // Open web browser and go to the TExcellent documentation page
  #ifdef _WIN64
    ShellExecuteW(this->Handle,
                  NULL,
                  L"http://www.code4sale.com/texcellent/TExcellentDocs.htm",
                  NULL,
                  NULL,
                  SW_SHOWNORMAL);
  #else
    ShellExecuteA(this->Handle,
                  NULL,
                  "http://www.code4sale.com/texcellent/TExcellentDocs.htm",
                  NULL,
                  NULL,
                  SW_SHOWNORMAL);
  #endif
}
//------------------------------------------------------------------------------



//------------------------------------------------------------------------------
void __fastcall TForm1::ButtonBuyFormPrinterClick(TObject *Sender)
{
  // Open web browser and go to the TExcellentFormPrinter BuyIt! page
  #ifdef _WIN64
    ShellExecuteW(this->Handle,
                  NULL,
                  L"http://www.code4sale.com/order/texcellentformprinter.htm",
                  NULL,
                  NULL,
                  SW_SHOWNORMAL);
  #else
    ShellExecuteA(this->Handle,
                  NULL,
                  "http://www.code4sale.com/order/texcellentformprinter.htm",
                  NULL,
                  NULL,
                  SW_SHOWNORMAL);
  #endif
}
//------------------------------------------------------------------------------



//------------------------------------------------------------------------------
void __fastcall TForm1::ButtonBuyImagePrinterClick(TObject *Sender)
//------------------------------------------------------------------------------
{
  // Open web browser and go to the TExcellentImagePrinter BuyIt! page
  #ifdef _WIN64
    ShellExecuteW(this->Handle,
                  NULL,
                  L"http://www.code4sale.com/order/texcellentimageprinter.htm",
                  NULL,
                  NULL,
                  SW_SHOWNORMAL);
  #else
    ShellExecuteA(this->Handle,
                  NULL,
                  "http://www.code4sale.com/order/texcellentimageprinter.htm",
                  NULL,
                  NULL,
                  SW_SHOWNORMAL);
  #endif
}
//------------------------------------------------------------------------------



//------------------------------------------------------------------------------
void __fastcall TForm1::LabelMailToSalesClick(TObject *Sender)
//------------------------------------------------------------------------------
{
  // Open web browser and go to TExcellent support email web page
  #ifdef _WIN64
    ShellExecuteW(this->Handle,
                  NULL,
                  L"http://www.code4sale.com/cgi-bin/emg.cgi?WebRet=http://www.code4sale.com/texcellent/index.htm&EmTo=sales&GetForm=TRUE",
                  NULL,
                  NULL,
                  SW_SHOWNORMAL);
  #else
    ShellExecuteA(this->Handle,
                  NULL,
                  "http://www.code4sale.com/cgi-bin/emg.cgi?WebRet=http://www.code4sale.com/texcellent/index.htm&EmTo=sales&GetForm=TRUE",
                  NULL,
                  NULL,
                  SW_SHOWNORMAL);
  #endif
}
//------------------------------------------------------------------------------



//------------------------------------------------------------------------------
void __fastcall TForm1::LabelMailToSupportClick(TObject *Sender)
//------------------------------------------------------------------------------
{
  // Open web browser and go to TExcellent support email web page
  #ifdef _WIN64
    ShellExecuteW(this->Handle,
                  NULL,
                  L"http://www.code4sale.com/cgi-bin/emg.cgi?WebRet=http://www.code4sale.com/texcellent/index.htm&EmTo=support&GetForm=TRUE",
                  NULL,
                  NULL,
                  SW_SHOWNORMAL);
  #else
    ShellExecuteA(this->Handle,
                  NULL,
                  "http://www.code4sale.com/cgi-bin/emg.cgi?WebRet=http://www.code4sale.com/texcellent/index.htm&EmTo=support&GetForm=TRUE",
                  NULL,
                  NULL,
                  SW_SHOWNORMAL);
  #endif
}
//------------------------------------------------------------------------------



//------------------------------------------------------------------------------
void __fastcall TForm1::LabelTryOfficialDemoApplicationClick(TObject *Sender)
//------------------------------------------------------------------------------
{
  // Open TExcellentDemo program or try to download it
  if (FileExists("TExcellentDemo.exe")) {
    WinExec("TExcellentDemo.exe",
            SW_SHOWNORMAL);
  } else {
    #ifdef _WIN64
      ShellExecuteW(this->Handle,
                    NULL,
                    L"http://www.code4sale.com/texcellent/TExcellentDemo.zip",
                    NULL,
                    NULL,
                    SW_SHOWNORMAL);
    #else
      ShellExecuteA(this->Handle,
                    NULL,
                    "http://www.code4sale.com/texcellent/TExcellentDemo.zip",
                    NULL,
                    NULL,
                    SW_SHOWNORMAL);
    #endif
  }
}
//------------------------------------------------------------------------------



//------------------------------------------------------------------------------
void __fastcall TForm1::ButtonTExcellentHomePageClick(TObject *Sender)
//------------------------------------------------------------------------------
{
  // Open web browser and go to TExcellent support email web page
  #ifdef _WIN64
    ShellExecuteW(this->Handle,
                  NULL,
                  L"http://www.code4sale.com/texcellent/index.htm",
                  NULL,
                  NULL,
                  SW_SHOWNORMAL);
  #else
    ShellExecuteA(this->Handle,
                  NULL,
                  "http://www.code4sale.com/texcellent/index.htm",
                  NULL,
                  NULL,
                  SW_SHOWNORMAL);
  #endif
}
//------------------------------------------------------------------------------
