


//------------------------------------------------------------------------------
//PrnUtils Version A.0
//Copyright (c) 1989-2010 by Joe C. Hecht All Rights Reserved
//Copyright (c) 2011-2015 by CODE4SALE, LLC All Rights Reserved
//License: Distribution of this source code prohibited, for inclusion
//in compiled form in your application only, use at your own risk,
//no liability accepted.
//TExcellentHomePage: www.code4sale.com/texcellent
//------------------------------------------------------------------------------



//------------------------------------------------------------------------------
//Note: Version 7.x changes center around support for CB++ XE3/4/5/6/7 Winx64.
//
//Notable changes include:
//
// TAppCallbackFn() is now TPrnFormAppCallbackFn and TPrnDibAppCallbackFn
//
// Some DWORD and PTR_UINT, and PTR_AS_UINT values are now:
// PRNFORM_PTR_UINT
// PRNFORM_PTR_AS_UINT
// PRNDIB_PTR_UINT
// PRNDIB_PTR_AS_UINT
// PRNUTILS_PTR_UINT
// PRNUTILS_PTR_AS_UINT
//------------------------------------------------------------------------------




//------------------------------------------------------------------------------
#ifndef PrnUtilsH
#define PrnUtilsH
//---------------------------------------------------------------------------



//------------------------------------------------------------------------------
#include <Graphics.hpp>
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
//---------------------------------------------------------------------------




//------------------------------------------------------------------------------
typedef size_t PRNUTILS_PTR_AS_UINT;
typedef size_t PRNUTILS_PTR_UINT;
//------------------------------------------------------------------------------



//------------------------------------------------------------------------------
#pragma pack(push, 1)
typedef struct _TPrnPageInfo
{
	RECT Margin;                //normal margins to printing area
	POINT PageSize;             //normal page (paper) size
	POINT PageArea;             //normal page image size
	RECT AdjustedMargin;        //adjusted margins (equal on all sizes)
	POINT AdjustedPageArea;     //page image size adjusted for equal margins
	POINT AdjustedMarginOffset; //amount to offset output for adjusted margins
	POINT DPI;                  //pixels per inch
} TPrnPageInfo, *PPrnPageInfo;
#pragma pack(pop)
//------------------------------------------------------------------------------



//------------------------------------------------------------------------------
BOOL __stdcall GetPrnPageInfo(HDC dc,
                              TPrnPageInfo * lpPrnPageInfo);
//------------------------------------------------------------------------------




//------------------------------------------------------------------------------
#pragma pack(push, 1)
typedef struct _TScaleInfo
{
    double OriginalSize_X;
    double OriginalSize_Y;
    double ScaledSize_X;
    double ScaledSize_Y;
    double ScaleFactor_X;
    double ScaleFactor_Y;
} TScaleInfo, *PScaleInfo;
#pragma pack(pop)
//------------------------------------------------------------------------------



//------------------------------------------------------------------------------
BOOL __stdcall ScaleToFitX(TScaleInfo * lpScaleInfo);
//------------------------------------------------------------------------------



//------------------------------------------------------------------------------
BOOL __stdcall ScaleToFitY(TScaleInfo * lpScaleInfo);
//------------------------------------------------------------------------------



//------------------------------------------------------------------------------
BOOL __stdcall ScaleToBestFit(TScaleInfo * lpScaleInfo);
//------------------------------------------------------------------------------



//------------------------------------------------------------------------------
#pragma pack(push, 1)
typedef struct _TPixelSizeInfo
{
    double DotsPerInch_X;
    double DotsPerInch_Y;
    double DotsPerMillimeter_X;
    double DotsPerMillimeter_Y;
    double DotsPerPoint_X;
    double DotsPerPoint_Y;
} TPixelSizeInfo, *PPixelSizeInfo;
#pragma pack(pop)
//------------------------------------------------------------------------------



//------------------------------------------------------------------------------
BOOL __stdcall GetPixelSizeInfo(HDC,
                                TPixelSizeInfo * lpPixelSizeInfo);
//------------------------------------------------------------------------------



//------------------------------------------------------------------------------
DWORD __stdcall GetNumPagesRequired(DWORD PrinterPageSize,
                                    DWORD ImageSize);
//------------------------------------------------------------------------------


//------------------------------------------------------------------------------
void * __stdcall GetMemEx(PRNUTILS_PTR_UINT size);
//------------------------------------------------------------------------------



//------------------------------------------------------------------------------
void * __stdcall FreeMemEx(void * p);
//------------------------------------------------------------------------------



//------------------------------------------------------------------------------
BOOL __stdcall LoadDIBFromStream(TStream * TheStream,
                                 PVOID * lpBitmapInfo,
                                 PVOID * lpBits,
                                 int * BitmapWidth,
                                 int * BitmapHeight);
//------------------------------------------------------------------------------



//------------------------------------------------------------------------------
BOOL __stdcall LoadDIBFromFile(const TFileName FileName,
                               PVOID * lpBitmapInfo,
                               PVOID * lpBits,
                               int * BitmapWidth,
                               int * BitmapHeight);
//------------------------------------------------------------------------------




//------------------------------------------------------------------------------
BOOL __stdcall LoadDIBFromTBitmap(Graphics::TBitmap * ABitmap,
                                  PVOID * lpBitmapInfo,
                                  PVOID * lpBits,
                                  int * BitmapWidth,
                                  int * BitmapHeight);
//------------------------------------------------------------------------------



//------------------------------------------------------------------------------
class TAbortDialog : public TForm
{
__published:	// IDE-managed Components
    TButton *btnCancel;
    void __fastcall btnCancelClick(TObject *Sender);
private:	// User declarations
    BOOL Canceled;
public:		// User declarations
    __fastcall TAbortDialog(TComponent* Owner);
    __fastcall BOOL Aborted();
};
//---------------------------------------------------------------------------
extern TAbortDialog *AbortDialog;
//---------------------------------------------------------------------------



//------------------------------------------------------------------------------
TAbortDialog* __stdcall CreateAbortDialog(HANDLE ApplicationHandle,
                                          Classes::TComponent* AOwner);
//------------------------------------------------------------------------------



//------------------------------------------------------------------------------
void __stdcall FreeAbortDialog(TAbortDialog* AbortDialog);
//------------------------------------------------------------------------------



//------------------------------------------------------------------------------
void __stdcall AbortDialogSetCaption(TAbortDialog* AbortDialog,
                                     TCaption ACaption);
//------------------------------------------------------------------------------



//------------------------------------------------------------------------------
BOOL __stdcall AbortDialogUserHasCanceled(TAbortDialog* AbortDialog);
//------------------------------------------------------------------------------


//------------------------------------------------------------------------------
typedef TAbortDialog TPrinterAbortDialog;
//------------------------------------------------------------------------------



//------------------------------------------------------------------------------
TPrinterAbortDialog* __stdcall CreatePrinterAbortDialog(HANDLE ApplicationHandle,
                                                        Classes::TComponent* AOwner);
//------------------------------------------------------------------------------



//------------------------------------------------------------------------------
void __stdcall FreePrinterAbortDialog(TPrinterAbortDialog* AbortDialog);
//------------------------------------------------------------------------------



//------------------------------------------------------------------------------
void __stdcall PrinterAbortDialogSetCaption(TPrinterAbortDialog* AbortDialog,
                                            TCaption ACaption);
//------------------------------------------------------------------------------



//------------------------------------------------------------------------------
BOOL __stdcall PrinterAbortDialogAborted(TPrinterAbortDialog* AbortDialog);
//------------------------------------------------------------------------------


//------------------------------------------------------------------------------
#endif
//------------------------------------------------------------------------------
