unit TExcellentExampleMain;



{$A+,B-,C-,D+,E-,F-,G+,H+,I+,J+,K-,L+,M-,N+,O+,P+,Q-,R-,S-,T-,U+,V+,W-,X+,Y+,Z1}
{$MINSTACKSIZE $00004000}
{$MAXSTACKSIZE $00100000}
{$IMAGEBASE $00400000}
{$APPTYPE GUI}



{$I TExcellentCompilerDefs.inc}


interface



{$IFDEF TEXCELLENT_DELPHI_VERSION_4_OR_BELOW}
uses
  Windows,
  Messages,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  StdCtrls,
  ExtCtrls,
  ShellAPI,
  Printers,
  PrnUtils,
  PrnForm,
  PrnDIB;
{$ELSE}
{$IFDEF TEXCELLENT_DELPHI_VERSION_NAMESPACING_REQUIRED}
uses
  Winapi.Windows,
  Winapi.Messages,
  System.SysUtils,
  System.Classes,
  Vcl.Graphics,
  Vcl.Controls,
  Vcl.Forms,
  Vcl.Dialogs,
  Vcl.StdCtrls,
  Vcl.ExtCtrls,
  Winapi.ShellAPI,
  Vcl.Printers,
{$ELSE}
uses
  Windows,
  Messages,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  StdCtrls,
  ExtCtrls,
  ShellAPI,
  Printers,
{$ENDIF}


{$IFDEF TEXCELLENT_WIN64}
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// x64 Build : Add Win64 platform, set to active, and totally rebuild.
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
{$ENDIF}
  PrnUtils,
  PrnForm,
  PrnDIB;
{$ENDIF}



type
  TForm1 = class(TForm)
     Image1: TImage;
     PrintDialog1: TPrintDialog;
     ButtonPrintImage: TButton;
     ButtonPrintForm: TButton;
     ButtonGetDocumentation: TButton;
     ButtonBuyFormPrinter: TButton;
     ButtonBuyImagePrinter: TButton;
     GroupBoxOptions: TGroupBox;
     CheckBoxUseDDB: TCheckBox;
     CheckBox24BitFormOutput: TCheckBox;
     LabelSeeFaqForOtherOptionsLineOne: TLabel;
     LabelSeeFaqForOtherOptionsLineTwo: TLabel;
     LabelTryOfficialDemoApplication: TLabel;
     GroupBoxQuestionsOrProblems: TGroupBox;
     LabelMailToSales: TLabel;
     LabelMailToSupport: TLabel;
     LabelTrialVersionNote: TLabel;
     GroupBoxReducePrintJobSize: TGroupBox;
     CheckBoxCompress: TCheckBox;
     CheckBoxWinStretch: TCheckBox;
     ButtonTExcellentHomePage: TButton;
     procedure FormCreate(Sender: TObject);
     procedure ButtonPrintFormClick(Sender: TObject);
     procedure ButtonPrintImageClick(Sender: TObject);
     procedure ButtonGetDocumentationClick(Sender: TObject);
     procedure ButtonBuyFormPrinterClick(Sender: TObject);
     procedure ButtonBuyImagePrinterClick(Sender: TObject);
     procedure LabelMailToSalesClick(Sender: TObject);
     procedure LabelMailToSupportClick(Sender: TObject);
     procedure LabelTryOfficialDemoApplicationClick(Sender: TObject);
    procedure ButtonTExcellentHomePageClick(Sender: TObject);
  private
      { Private declarations }
  public
    { Public declarations }
  end;


var
  Form1: TForm1;

implementation

{$R *.DFM}


{------------------------------------------------------------------------------}
procedure TForm1.FormCreate(Sender: TObject);
{------------------------------------------------------------------------------}
begin
  self.Caption := 'TExcellent Form & Image Printer - VA.1';
  {$IFDEF TEXCELLENT_DELPHI_VERSION_1}
    self.Caption := self.Caption + '-Pas1';
  {$ENDIF}
  {$IFDEF TEXCELLENT_DELPHI_VERSION_2}
    self.Caption := self.Caption + '-Pas2';
  {$ENDIF}
  {$IFDEF TEXCELLENT_DELPHI_VERSION_3}
    self.Caption := self.Caption + '-Pas3';
  {$ENDIF}
  {$IFDEF TEXCELLENT_DELPHI_VERSION_4}
    self.Caption := self.Caption + '-Pas4';
  {$ENDIF}
  {$IFDEF TEXCELLENT_DELPHI_VERSION_5}
    self.Caption := self.Caption + '-Pas5';
  {$ENDIF}
  {$IFDEF TEXCELLENT_DELPHI_VERSION_6}
    self.Caption := self.Caption + '-Pas6';
  {$ENDIF}
  {$IFDEF TEXCELLENT_DELPHI_VERSION_7}
    self.Caption := self.Caption + '-Pas7';
  {$ENDIF}
  {$IFDEF TEXCELLENT_DELPHI_VERSION_8}
    self.Caption := self.Caption + '-Pas8';
  {$ENDIF}
  {$IFDEF TEXCELLENT_DELPHI_VERSION_2005}
    self.Caption := self.Caption + '-Pas2005';
  {$ENDIF}
  {$IFDEF TEXCELLENT_DELPHI_VERSION_2006}
    self.Caption := self.Caption + '-Pas2006';
  {$ENDIF}
  {$IFDEF TEXCELLENT_DELPHI_VERSION_2007}
    self.Caption := self.Caption + '-Pas2007';
  {$ENDIF}
  {$IFDEF TEXCELLENT_DELPHI_VERSION_2009}
    self.Caption := self.Caption + '-Pas2009';
  {$ENDIF}
  {$IFDEF TEXCELLENT_DELPHI_VERSION_2010}
    self.Caption := self.Caption + '-Pas2010';
  {$ENDIF}
  {$IFDEF TEXCELLENT_DELPHI_VERSION_XE}
    self.Caption := self.Caption + '-PasXE';
  {$ENDIF}
  {$IFDEF TEXCELLENT_DELPHI_VERSION_XE2}
    self.Caption := self.Caption + '-PasXE2';
  {$ENDIF}
  {$IFDEF TEXCELLENT_DELPHI_VERSION_XE3}
    self.Caption := self.Caption + '-PasXE3';
  {$ENDIF}
  {$IFDEF TEXCELLENT_DELPHI_VERSION_XE4}
    self.Caption := self.Caption + '-PasXE4';
  {$ENDIF}
  {$IFDEF TEXCELLENT_DELPHI_VERSION_XE5}
    self.Caption := self.Caption + '-PasXE5';
  {$ENDIF}
  {$IFDEF TEXCELLENT_DELPHI_VERSION_XE6}
    self.Caption := self.Caption + '-PasXE6';
  {$ENDIF}
  {$IFDEF TEXCELLENT_DELPHI_VERSION_XE7}
    self.Caption := self.Caption + '-PasXE7';
  {$ENDIF}
  {$IFDEF TEXCELLENT_DELPHI_VERSION_XE8}
    self.Caption := self.Caption + '-PasXE8';
  {$ENDIF}
  {$IFDEF TEXCELLENT_DELPHI_VERSION_XE0A}
    self.Caption := self.Caption + '-PasXE10';
  {$ENDIF}
  {$IFDEF TEXCELLENT_DELPHI_VERSION_XE0A01}
    self.Caption := self.Caption + '-PasXE1001';
  {$ENDIF}
  case sizeof(pointer) of
    4 : self.Caption := self.Caption + 'x86';
    8 : self.Caption := self.Caption + 'x64';
  end;
 {Load test.bmp into the Image1 component}
  if (NOT FileExists('test.bmp')) then begin
    if (NOT FileExists('..\test.bmp')) then begin
      if (NOT FileExists('..\..\test.bmp')) then begin
        ShowMessage('Error - test.bmp not found!');
      end else begin
        Image1.Picture.Bitmap.LoadFromFile('..\..\test.bmp');
      end;
	end else begin
      Image1.Picture.Bitmap.LoadFromFile('..\test.bmp');
    end;
  end else begin
    Image1.Picture.Bitmap.LoadFromFile('test.bmp');
  end;
 {$IFDEF TEXCELLENT_DELPHI_VERSION_2}
   LabelMailToSales.Cursor := crDrag;
   LabelMailToSupport.Cursor := crDrag;
   LabelTryOfficialDemoApplication.Cursor := crDrag;
 {$ELSE}
   LabelMailToSales.Cursor := crHandPoint;
   LabelMailToSupport.Cursor := crHandPoint;
   LabelTryOfficialDemoApplication.Cursor := crHandPoint;
 {$ENDIF}
end;
{------------------------------------------------------------------------------}



{------------------------------------------------------------------------------}
{Print the form scaled to a full page - with options!}
procedure TForm1.ButtonPrintFormClick(Sender: TObject);
{------------------------------------------------------------------------------}
var
  PrintOptions : TPrintFormData;
  PrnPageInfo : TPrnPageInfo;   {Info about the page to be printed}
begin

  {Let the button repaint itself from the click event}
  Application.ProcessMessages();


 {Are we printing something right now?}
  if (Printer.Printing) then begin
    ShowMessage('Already printing... Please try again later!');
    exit;
  end;

 {Let the user select a printer}
  if (NOT PrintDialog1.Execute) then begin
    exit;
  end;

 {Prepare to set printing options}
  FillChar(PrintOptions, sizeof(PrintOptions), 0);
  PrintOptions.StrucSize := sizeof(PrintOptions);

 {Lets show a status dialog during the print job!}
  PrintOptions.UseAbortDialog := TRUE;

 {Lets show messages if there are problems printing the form}
  PrnFormSetDebugMsg(TRUE);

 {Allow the user to force the use 24 bit printing for problem printers}
  PrintOptions.Use24BitOutputOnly := CheckBox24BitFormOutput.Checked;

 {Allow user to force the use of DDBs for problem printers or speed up the print job}
  PrnFormSetDebugUseDDB(CheckBoxUseDDB.Checked);

  {Set print job size reduction factor}
  if (CheckBoxCompress.Checked) then begin
    PrnFormSetOutputScaleFactor(2, 2);
  end else begin
    PrnFormSetOutputScaleFactor(1, 1);
  end;

  {Set WinScale}
  if (CheckBoxWinStretch.Checked) then begin
    PrnFormSetOutputScaleFactor(1, 1);
    PrnFormSetDoWinScale(TRUE);
  end else begin
    PrnFormSetDoWinScale(FALSE);
  end;

 {Start the print job!}
  Printer.BeginDoc;

 {Print the form!}
  if (NOT PrintFormEx(self,
                      Printer.Canvas.Handle,
                      TRUE, {Center the form on the page}
                      TRUE, {Adjust for perfect margins}
                      @PrintOptions)) then begin
   {Abort the print job!}
    Printer.Abort;
    ShowMessage('User abort or other error!');
  end else begin
   {get the page information}
    GetPrnPageInfo(Printer.Handle,
                   @PrnPageInfo);
   {print a notice that demo mode prints lines across the output}
    Printer.Canvas.Font.Name := 'Arial';
    Printer.Canvas.Font.Size := 12;
    Printer.Canvas.TextOut(PrnPageInfo.Margin.left,
                           PrnPageInfo.Margin.top,
                           'Note: Demo mode prints lines across the output.');
   {End the print job!}
    Printer.EndDoc;
  end;

 {We are done!}
  ShowMessage('Printing Completed!');

end;
{------------------------------------------------------------------------------}



{------------------------------------------------------------------------------}
{A callback function for updating an image printer abort dialog!}
function ImagePrinterCallbackFunction(UnitsDone : DWORD;
                                      TotalUnits : DWORD;
                                      AbortDialog : TAbortDialog) : BOOL; stdcall;
{------------------------------------------------------------------------------}
var
  ACaption : TCaption;
begin
 {Update the abort dialogs caption to give a status update}
  ACaption := 'Printing - ' +
              IntToStr(Trunc(((UnitsDone / TotalUnits) * 100))) +
              '%';
  AbortDialogSetCaption(AbortDialog,
                        ACaption);
 {Should we continue?}
  result := (NOT AbortDialogUserHasCanceled(AbortDialog));
end;
{------------------------------------------------------------------------------}



{------------------------------------------------------------------------------}
{Print test.bmp scaled to a full page - with abort dialog!}
procedure TForm1.ButtonPrintImageClick(Sender: TObject);
{------------------------------------------------------------------------------}
var
  FileName : TFileName;          {The filename of the image}
  AbortDialog : TAbortDialog;    {The abort dialog}
  BitmapInfo : PBITMAPINFO;      {A pointer to a BitmapInfo structure}
  Bits : pointer;                {A pointer to the bitmap bits}
  BitmapWidth : integer;         {The bitmap width}
  BitmapHeight : integer;        {The bitmap height}
  PrnPageInfo : TPrnPageInfo;         {Info about the page to be printed}
begin

  {Let the button repaint itself from the click event}
  Application.ProcessMessages();


 {Are we printing something right now?}
  if (Printer.Printing) then begin
    ShowMessage('Already printing... Please try again later!');
    exit;
  end;

 {Do we have a bitmap to print?}
  if (NOT FileExists('test.bmp')) then begin
    if (NOT FileExists('..\test.bmp')) then begin
      if (NOT FileExists('..\..\test.bmp')) then begin
        ShowMessage('Error - test.bmp not found!');
      end else begin
        FileName := '..\..\test.bmp';
      end;
	end else begin
      FileName := '..\test.bmp';
    end;
  end else begin
    FileName := 'test.bmp';
  end;


 {Let the user select a printer}
  if (NOT PrintDialog1.Execute) then begin
    exit;
  end;

 {Load test.bmp as a Device Independent Bitmap}
  if (NOT LoadDIBFromFile(FileName,
                          pointer(BitmapInfo),
                          Bits,
                          BitmapWidth,
                          BitmapHeight)) then begin
      ShowMessage('Bitmap load error');
    exit;
  end;

 {Create the abort dialog}
  AbortDialog := CreateAbortDialog(Application.Handle, self);
  PrnDIBSetAbortDialogHandle(AbortDialog.Handle);

 {Lets show messages if there are problems printing the form}
  PrnDIBSetDebugMsg(TRUE);

 {Allow user to force the use of DDBs for problem printers or speed up the print job}
  PrnDIBSetDebugUseDDB(CheckBoxUseDDB.Checked);

  {Set print job size reduction factor}
  if (CheckBoxCompress.Checked) then begin
    PrnDIBSetOutputScaleFactor(2, 2);
  end else begin
    PrnDIBSetOutputScaleFactor(1, 1);
  end;

  {Set WinScale}
  if (CheckBoxWinStretch.Checked) then begin
    PrnDIBSetDoWinScale(TRUE);
    PrnDIBSetOutputScaleFactor(1, 1);
  end else begin
    PrnDIBSetDoWinScale(FALSE);
  end;

 {Start the print job!}
  Printer.BeginDoc;

 {Print the image!}
  if (PrintDIBitmapCB(Printer.Canvas.Handle,
                      BitmapInfo,
                      Bits,
                      TRUE,
                      TRUE,
                      TPrnDibAppCallbackFn(@ImagePrinterCallbackFunction),
                      PRNDIB_PTR_AS_UINT(AbortDialog)) < PRINT_SUCCESSFUL) then begin
   {Abort the print job!}
    Printer.Abort;
    ShowMessage('User abort or other error!');
  end else begin
   {get the page information}
     GetPrnPageInfo(Printer.Handle,
                    @PrnPageInfo);
    {print a notice that demo mode prints lines across the output}
    Printer.Canvas.Font.Name := 'Arial';
    Printer.Canvas.Font.Size := 12;
    Printer.Canvas.TextOut(PrnPageInfo.Margin.left,
                           PrnPageInfo.Margin.top,
                           'Note: Demo mode prints lines across the output.');
   {End the print job!}
    Printer.EndDoc;
  end;

 {Clean Up!}
  FreeMemEx(BitmapInfo);
  FreeMemEx(Bits);
  FreeAbortDialog(AbortDialog);
  PrnDIBSetAbortDialogHandle(0);

 {We are done!}
  ShowMessage('Printing Completed!');

end;
{------------------------------------------------------------------------------}



{------------------------------------------------------------------------------}
procedure TForm1.ButtonGetDocumentationClick(Sender: TObject);
{------------------------------------------------------------------------------}
begin
  {Open web browser and go to the TExcellent documentation page}
  ShellExecute(Form1.Handle,
               nil,
               'http://www.code4sale.com/texcellent/TExcellentDocs.htm',
               nil,
               nil,
               SW_SHOWNORMAL);
end;
{------------------------------------------------------------------------------}



{------------------------------------------------------------------------------}
procedure TForm1.ButtonBuyFormPrinterClick(Sender: TObject);
{------------------------------------------------------------------------------}
begin
  {Open web browser and go to the TExcellentFormPrinter BuyIt! page}
  ShellExecute(Form1.Handle,
               nil,
               'http://www.code4sale.com/order/texcellentformprinter.htm',
               nil,
               nil,
               SW_SHOWNORMAL);
end;
{------------------------------------------------------------------------------}



{------------------------------------------------------------------------------}
procedure TForm1.ButtonBuyImagePrinterClick(Sender: TObject);
{------------------------------------------------------------------------------}
begin
 {Open web browser and go to the TExcellentImagePrinter BuyIt! page}
  ShellExecute(Form1.Handle,
               nil,
               'http://www.code4sale.com/order/texcellentimageprinter.htm',
               nil,
               nil,
               SW_SHOWNORMAL);
end;
{------------------------------------------------------------------------------}



{------------------------------------------------------------------------------}
procedure TForm1.LabelMailToSalesClick(Sender: TObject);
{------------------------------------------------------------------------------}
begin
  {Open web browser and go to TExcellent support email web page}
  ShellExecute(Form1.Handle,
               nil,
               'http://www.code4sale.com/cgi-bin/emg.cgi?WebRet=http://www.code4sale.com/texcellent/index.htm&EmTo=sales&GetForm=TRUE',
               nil,
               nil,
               SW_SHOWNORMAL);
end;
{------------------------------------------------------------------------------}



{------------------------------------------------------------------------------}
procedure TForm1.LabelMailToSupportClick(Sender: TObject);
{------------------------------------------------------------------------------}
begin
  {Open web browser and go to TExcellent support email web page}
  ShellExecute(Form1.Handle,
               nil,
               'http://www.code4sale.com/cgi-bin/emg.cgi?WebRet=http://www.code4sale.com/texcellent/index.htm&EmTo=support&GetForm=TRUE',
               nil,
               nil,
               SW_SHOWNORMAL);
end;
{------------------------------------------------------------------------------}



{------------------------------------------------------------------------------}
procedure TForm1.LabelTryOfficialDemoApplicationClick(Sender: TObject);
{------------------------------------------------------------------------------}
begin
 {Open TExcellentDemo program or try to download it}
  if (FileExists('TExcellentDemo.exe')) then begin
    WinExec('TExcellentDemo.exe',
            SW_SHOWNORMAL);
  end else begin
    ShellExecute(Form1.Handle,
                 nil,
                 'http://www.code4sale.com/texcellent/TExcellentDemo.zip',
                 nil,
                 nil,
                 SW_SHOWNORMAL);
  end;
end;
{------------------------------------------------------------------------------}



{------------------------------------------------------------------------------}
procedure TForm1.ButtonTExcellentHomePageClick(Sender: TObject);
{------------------------------------------------------------------------------}
begin
  {Open web browser and go to TExcellent web page}
  ShellExecute(Form1.Handle,
               nil,
               'http://www.code4sale.com/texcellent/index.htm',
               nil,
               nil,
               SW_SHOWNORMAL);
end;
{------------------------------------------------------------------------------}




{------------------------------------------------------------------------------}
end.
